package gov.va.genisis2.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

import gov.va.genisis2.vo.CopyTableDomains;
import gov.va.genisis2.vo.CopyTableSource;

@Configuration
@ComponentScan(basePackages = { "gov.va.genisis2.*" })
public class GenisisPropertiesUtil {

	
	@Value("${tablecopy.db.copy_script_cmd_filepath}")
	private String cmdFilePath;

	private String tableName;

	private String sourceSchemaName;

	private String destinationSchemaName;

	// Table Copy new Attributes
	@Value("${tablecopy.db.source.server.name}")
	private String tcSourceDataBaseServerName;

	@Value("${tablecopy.db.source.server.database.name}")
	private String tcSourceDataBaseName;

	@Value("${tablecopy.db.destination.server.name}")
	private String tcDestinationDataBaseServerName;

	@Value("${tablecopy.db.destination.user.name}")
	private String tcDestinationDataBaseUserName;

	@Value("${tablecopy.db.destination.user.password}")
	private String tcDestinationDataBaseUserPassword;

	@Value("${tablecopy.db.destination.server.database.name}")
	private String tcDestinationServerDataBaseName;

	@Value("${tablecopy.db.management.database.server.name}")
	private String tcManagementDataBaseServerName;

	@Value("${tablecopy.db.management.username}")
	private String tcManagementDataBaseUserName;

	@Value("${tablecopy.db.management.password}")
	private String tcManagementDataBaseUserPassword;

	@Value("${tablecopy.db.management.schema}")
	private String tcManagementDataBaseSchema;

	@Value("${tablecopy.db.source.user.name}")
	private String tcSourceDataBaseUserName;

	@Value("${tablecopy.db.management.database.name}")
	private String tcManagementDataBaseName;

	@Value("${tablecopy.db.temporary.database.name}")
	private String tcTemporaryDataBaseName;
	
	@Value("${genisis2.pom.props.path}")
	private String genisisPomPropsPath;


	/**
	 * @return genisisPomPropsPath
	 */
	public String getGenisisPomPropsPath() {
		return genisisPomPropsPath;
	}
	
	/**
	 * sets genisisPomPropsPath
	 * 
	 * @param genisisPomPropsPath genisisPomPropsPath 
	 */
	public void setGenisisPomPropsPath(String genisisPomPropsPath) {
		this.genisisPomPropsPath = genisisPomPropsPath;
	}
	
	@Bean
	protected CopyTableDomains getCopyTableDomainsDetails() {
		return new CopyTableDomains(tcSourceDataBaseName, tcDestinationServerDataBaseName, tcSourceDataBaseServerName,
				tcDestinationDataBaseServerName, tcSourceDataBaseUserName, tcDestinationDataBaseUserName);
	}

	@Bean
	protected CopyTableSource getCopyTableSource() {
		return new CopyTableSource(tableName, tcSourceDataBaseServerName, tcSourceDataBaseName, sourceSchemaName,
				tcDestinationDataBaseServerName, tcDestinationDataBaseUserName, tcDestinationDataBaseUserPassword,
				tcDestinationServerDataBaseName, destinationSchemaName, tcManagementDataBaseServerName,
				tcManagementDataBaseUserName, tcManagementDataBaseUserPassword, tcManagementDataBaseSchema, cmdFilePath,
				tcManagementDataBaseName, tcTemporaryDataBaseName);
	}
}
